function Item(name, type, cost, effect, atk, def, mdef, extra)
{
	this.name = name;
	this.type = type;
	this.icon = LoadImage(type + "-icon.png");
	this.cost = cost;
	this.effect = effect;
	this.atk = atk;
	this.def = def;
	this.mdef = mdef;
	this.description = extra;
	this.amount = 0;
}

Item.prototype.clone = function()
{
	var item = new Item(this.name, this.type, this.cost, this.effect, this.atk, this.def, this.mdef, this.extra);
	item.amount = this.amount;
	return item;
}

Item.prototype.add = function(amount, destination)
{
	for (var i = 0; i < destination.length; i ++)
	{
		if (destination[i].name == this.name)
		{
			destination[i].amount += amount;
			return;
		}
	}
	destination[destination.length] = this.clone();
	destination[destination.length - 1].amount = amount;
}

Item.prototype.minus = function(amount)
{
	Game.items[this.name].amount -= amount;
	if (Game.items[this.name].amount <= 0)
		Game.items[this.name] = undefined;
}

var Items = new Object();
Items.Consumables = new Object();
Items.Weapons = new Array();
Items.Weapons[0] = new Item("Wooden Blade", "Long Sword", 50, "", 3);
Items.Weapons[0].amount = 1;
Items.Weapons[1] = new Item("Ultima Weapon", "Long Sword", 50, "", 93, 0, 0, "The Ultimate weapon held by Damizean");
Items.Weapons[1].amount = 3;
Items.Weapons[2] = new Item("Big Stick", "Long Sword", 60, "", 23);
Items.Weapons[2].amount = 15;
Items.Armor = new Object();
Items.Armor[0] = new Item("Leather Hat", "Hat", 50, "", 0, 2, 1, "Little hat made of leather");
Items.Rare = new Object();
Items.Blank = new Item("", "Long Sword", 0, "", 0, 0, 0);